const bookList = document.getElementById("book-list");
const addBookForm = document.getElementById("add-book-form");
const books = [];

//create row in book list
function renderBookList() {
  bookList.innerHTML = "";
  for (let i = 0; i < books.length; i++) {
    const book = books[i];
    const listItem = document.createElement("li");
    listItem.innerHTML = `${book.title.bold()} by ${book.author} (${book.year}) ${book.genre} <button class="remove-book" data-index="${i}">Remove</button>`;
    bookList.appendChild(listItem);
      }
}

//add book to list
function addBook() {
  event.preventDefault();
  const title = document.getElementById("nosaukums").value;
  const author = document.getElementById("autors").value;
  const year = document.getElementById("izd_gads").value;
  const genre = document.getElementById("zanrs").value;
  books.push({title, author, year, genre});
  renderBookList();
 // addBookForm.reset();
}

//remove book from list
function removeBook(event) {
  if (event.target.classList.contains("remove-book")) {
    const index = event.target.dataset.index;
    books.splice(index, 1);
    renderBookList();
  }
}

//export data to excel
function excel(tableID, filename = ''){
  var downloadLink;
  var dataType = 'application/vnd.ms-excel';
  var tableSelect = document.getElementById(tableID);
  var tableHTML = tableSelect.outerHTML.replace(/ /g, '%20');
  
  // Specify file name
  filename = filename?filename+'.xls':'excel_data.xls';
  
  // Create download link element
  downloadLink = document.createElement("a");
  
  document.body.appendChild(downloadLink);
  
  if(navigator.msSaveOrOpenBlob){
      var blob = new Blob(['\ufeff', tableHTML], {
          type: dataType
      });
      navigator.msSaveOrOpenBlob( blob, filename);
  }else{
      // Create a link to the file
      downloadLink.href = 'data:' + dataType + ', ' + tableHTML;
  
      // Setting the file name
      downloadLink.download = filename;
      
      //triggering the function
      downloadLink.click();
  }
}

function addRow()
  {
    var nosaukums = document.getElementById('nosaukums').value;
    var autors = document.getElementById('autors').value;
    var izd_gads = document.getElementById('izd_gads').value;
    var zanrs = document.getElementById('zanrs').value;
              
      // creates table
      var table = document.getElementsByTagName('table')[0];
              
      // new row
      var newRow = table.insertRow(table.rows.length/2+1);
              
      // add cells to row
      var cel1 = newRow.insertCell(0);
      var cel2 = newRow.insertCell(1);
      var cel3 = newRow.insertCell(2);
      var cel4 = newRow.insertCell(3);
              
      // values in the cells
      cel1.innerHTML = nosaukums;
      cel2.innerHTML = autors;
      cel3.innerHTML = izd_gads;
      cel4.innerHTML = zanrs;

     event.preventDefault();
}

bookList.addEventListener("click", removeBook);